<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Check current status column definition
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'status'");
    $columnInfo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($columnInfo) {
        echo "Current status column type: " . $columnInfo['Type'] . "\n";
        
        // If it's an ENUM, we need to modify it to include 'refunded'
        if (strpos($columnInfo['Type'], 'enum') !== false) {
            // Extract current enum values
            preg_match("/enum\((.*)\)/", $columnInfo['Type'], $matches);
            $currentValues = $matches[1];
            
            // Add 'refunded' to the enum values if it's not already there
            if (strpos($currentValues, "'refunded'") === false) {
                $newValues = $currentValues . ",'refunded'";
                $sql = "ALTER TABLE credit_payments MODIFY COLUMN status ENUM($newValues) DEFAULT 'completed'";
                echo "Executing SQL: $sql\n";
                $pdo->exec($sql);
                echo "Updated status column to include 'refunded'\n";
            } else {
                echo "'refunded' is already in the status enum values\n";
            }
        } else {
            // If it's not an ENUM, convert it to VARCHAR to allow any value
            $pdo->exec("ALTER TABLE credit_payments MODIFY COLUMN status VARCHAR(50) DEFAULT 'completed'");
            echo "Converted status column to VARCHAR(50)\n";
        }
    } else {
        echo "status column not found in credit_payments table\n";
    }
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Error updating status column: " . $e->getMessage() . "\n";
} 